//---------------------------------------------------------
#ifndef usb_R9_3H
#define usb_R9_3H
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <setupapi.h>
#include <assert.h>
//---------------------------------------------------------
#define searchMaxDevices 100
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//--------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _DEVICE_DATA {
  TCHAR   *HardwareId;
  TCHAR   *Path;
  DWORD   DeviceInstance;
  HANDLE  hidDeviceObject;
  BYTE    *inputReportBuffer;
  USHORT  inputReportByteLength;
  /*...*/
  USHORT  outputReportByteLength;
  USHORT  featureReportByteLength;
  /*...*/
  PHIDP_PREPARSED_DATA preparsedData;
  HIDP_CAPS capabilities;
} DEVICE_DATA, *PDEVICE_DATA;
//---------------------------------------------------------
class TUSBDevice {
   private:
      UINT fMemberIndex;
      void displayError(const char* msg);
   public:
      PDEVICE_DATA deviceList;
      BOOL getHidDeviceCapabilities(UINT memberIndex);
      UINT setGetHidDeviceData();
      HANDLE openHidUSBDevice(UINT memberIndex);
      BOOL readUSBReport(UINT memberIndex);
      BOOL closeHidUSBDevice(HANDLE devHandle);
      TUSBDevice(UINT memberIndex);
      ~TUSBDevice();
};
//---------------------------------------------------------
class TForm1 : public TForm
{
  __published:	// IDE-managed Components
     TButton *Button1;
     TTrackBar *TrackBar1;
     TMemo *Memo1;
     TListView *ListView1;
     void __fastcall Button1Click(TObject *Sender);
     void __fastcall FormClose(TObject *Sender,
                               TCloseAction &Action);
  private:	// User declarations
     TUSBDevice *usbDevice;
  public:    	// User declarations
     __fastcall TForm1(TComponent* Owner);
     TListItem  *ListItem;
};
//---------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------
#endif
